/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.screen;

import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

public class ScreenUtilities {
    static final ResourceLocation GENERIC_PROGRESS_BAR_LOCATION = new ResourceLocation("lazrslib", "textures/gui/progress_bar.png");

    public static void drawTexture(GuiGraphics graphics, BlitCoordinates pos, ScreenTexture texture) {
        graphics.m_280411_(texture.getResourceLocation(), pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), texture.getU(), texture.getV(), texture.getBoundsX(), texture.getBoundsY(), texture.getWidth(), texture.getHeight());
    }

    public static void drawTexture(GuiGraphics graphics, BlitCoordinates pos, float rotation, ScreenTexture texture) {
        ScreenUtilities.drawTexture(graphics, pos, rotation, pos.getWidth() / 2, pos.getHeight() / 2, texture);
    }

    public static void drawTexture(GuiGraphics graphics, BlitCoordinates pos, float rotation, float rotateAroundX, float rotateAroundY, ScreenTexture texture) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_272245_(Axis.f_252403_.m_252977_(rotation), (float)pos.getX() + rotateAroundX, (float)pos.getY() + rotateAroundY, 0.0f);
        graphics.m_280411_(texture.getResourceLocation(), pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), texture.getU(), texture.getV(), texture.getBoundsX(), texture.getBoundsY(), texture.getWidth(), texture.getHeight());
        graphics.m_280168_().m_85849_();
    }

    public static void drawProgressBar(GuiGraphics graphics, BlitCoordinates pos, ScreenTexture texture, float progress, int totalFramesHorizontal, int totalFramesVertically) {
        int frames = totalFramesHorizontal * totalFramesVertically;
        int frameIndex = Mth.m_14143_((float)((float)frames * progress));
        int column = Mth.m_14143_((float)((float)frameIndex % (float)totalFramesHorizontal));
        int row = Mth.m_14143_((float)((float)frameIndex / (float)totalFramesHorizontal));
        float uvXF = texture.getU() + (float)(column * texture.getBoundsX());
        float uvYF = texture.getV() + (float)(row * texture.getBoundsY());
        graphics.m_280411_(texture.getResourceLocation(), pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), uvXF, uvYF, texture.getBoundsX(), texture.getBoundsY(), texture.getWidth(), texture.getHeight());
    }

    public static void drawGenericProgressBar(GuiGraphics graphics, BlitCoordinates pos, float progress) {
        graphics.m_280509_(pos.getX(), pos.getY(), pos.getX() + pos.getWidth(), pos.getY() + 2, 0x4F000000);
        int i = Mth.m_14169_((float)(progress / 3.0f), (float)1.0f, (float)1.0f);
        graphics.m_280509_(pos.getX(), pos.getY(), pos.getX() + (int)((float)pos.getWidth() * progress), pos.getY() + 1, i | 0xFF000000);
    }

    public static void drawGenericProgressBarUpright(GuiGraphics graphics, BlitCoordinates pos, float progress, float partialTick) {
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)2.0f);
        int shakeX = 0;
        if (progress > 1.0f) {
            shakeX = Mth.m_14143_((float)(Mth.m_14031_((float)(partialTick * (100.0f * (progress - 1.0f)) * 2.0f)) - 1.0f));
        }
        graphics.m_280509_(pos.getX() + shakeX, pos.getY(), pos.getX() + 2 + shakeX, pos.getY() + pos.getHeight(), 0x4F000000);
        int i = Mth.m_14169_((float)(progress / 3.0f), (float)1.0f, (float)1.0f);
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        graphics.m_280509_(pos.getX() + shakeX, pos.getY() + pos.getHeight(), pos.getX() + 1 + shakeX, pos.getY() + pos.getHeight() - (int)((float)pos.getHeight() * progress), i | 0xFF000000);
    }

    public static void renderLabel(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int color, boolean renderShadow) {
        String text;
        int i;
        int space = 15;
        int width = 0;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            width = Math.max(width, instance.f_91062_.m_92895_(text) + 10);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            graphics.m_280056_(instance.f_91062_, text, x - instance.f_91062_.m_92895_(text) / 2, y + (list.size() / 2 * space + space * i), color, renderShadow);
        }
        RenderSystem.enableDepthTest();
    }

    public static void renderLabel(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int color) {
        ScreenUtilities.renderLabel(instance, graphics, x, y, list, color, true);
    }

    public static void drawParagraph(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int maxWidth, int color, boolean renderShadow) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        FormattedText text = FormattedText.m_130768_(list);
        graphics.m_280554_(instance.f_91062_, text, x, y, maxWidth, color);
        RenderSystem.enableDepthTest();
    }

    public static void drawParagraph(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int maxWidth, int color) {
        ScreenUtilities.drawParagraph(instance, graphics, x, y, list, maxWidth, color, true);
    }

    public static void drawParagraph(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, List<Component> list, int color) {
        ScreenUtilities.drawParagraph(instance, graphics, pos.getX(), pos.getY(), list, pos.getWidth(), color, true);
    }

    public static void drawParagraph(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, List<Component> list, int color, boolean renderShadow) {
        ScreenUtilities.drawParagraph(instance, graphics, pos.getX(), pos.getY(), list, pos.getWidth(), color, renderShadow);
    }

    public static void drawItemStack(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull ItemStack stack, int x, int y) {
        ScreenUtilities.drawItemStack(instance, graphics, stack, x, y, 16);
    }

    public static void drawItemStack(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull ItemStack stack, int x, int y, int size) {
        if (!stack.m_41619_()) {
            BakedModel bakedmodel = instance.m_91291_().m_174264_(stack, (Level)instance.f_91073_, null, 0);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(x + size / 2), (float)(y + size / 2), (float)(150 + (bakedmodel.m_7539_() ? 0 : 0)));
            try {
                boolean flag;
                graphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                graphics.m_280168_().m_85841_((float)size, (float)size, (float)size);
                boolean bl = flag = !bakedmodel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                instance.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
                graphics.m_280262_();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
                crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
                throw new ReportedException(crashreport);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    public static boolean mouseInArea(double mouseX, double mouseY, ScreenRect area) {
        return area.positionEnvlopes(mouseX, mouseY);
    }
}

